﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kadry" %>
<%@ Import Namespace="Soneta.Deklaracje" %>
<%@ import Namespace="System.Collections.Generic" %>

<script runat="server">
	 
    static string empty = "<b>BRAK</b>";

    class Pozycja {
        string blok;
        public string Blok {
            get { return blok; }
            set { blok = value; }
        }
        string pole;
        public string Pole {
            get { return pole; }
            set { pole = value; }
        }
        string numer;
        public string Numer {
            get { return numer; }
            set { numer = value; }
        }
        string wartosc;
        public string Wartosc {
            get { return wartosc; }
            set { wartosc = value; }
        }
        string tytul;
        public string Tytul {
            get { return tytul; }
            set { tytul = value; }
        }
        string opis;
        public string Opis {
            get { return opis; }
            set { opis = value; }
        }
        bool wymagane;
        public bool Wymagane {
            get { return wymagane; }
            set { wymagane = value; }
        }
        public Pozycja(string blok, string tytul, string pole, string numer, string opis, string wartosc, bool wymagane) {
            this.blok = blok;
            this.tytul = tytul;
            this.pole = pole;
            this.numer = numer;
            this.opis = opis;
            this.wymagane = wymagane;
            Przypisz(wartosc);
        }
        public bool Porownaj(string blok, string pole) {
            return (this.blok == blok && this.pole == pole);
        }
        public void Przypisz(string wartosc) {
            if (wymagane)
                this.wartosc = (wartosc.Length != 0) ? wartosc : empty;
            else
                this.wartosc = wartosc;
        }
    }

    public class Params : ContextBase {
        public Params(Context context) : base(context) {
        }

        bool braki;
        [Caption("Pokaż tylko braki")]
        public bool Braki {
            get { return braki; }
            set {
                braki = value;
                OnChanged(EventArgs.Empty);
            }
        }
    }

    Params pars;
    [Context]
    public Params Pars {
        set { pars = value; }
    }
    
    void OnContextLoad(Object sender, EventArgs e) {
        Soneta.Deklaracje.ZUS.ZCNA zcna = (Soneta.Deklaracje.ZUS.ZCNA)dc[typeof(Soneta.Deklaracje.ZUS.ZCNA)];
        if (zcna == null)
            throw new Exception("Wydruk przeznaczony tylko dla deklaracji ZCNA");
        
        List<Pozycja> pozycje = new List<Pozycja>();
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby ubezpieczonej", "p1", "1", "Numer Pesel", "", true));
        pozycje.Add(new Pozycja("III", "Dane identyfikacyjne osoby ubezpieczonej", "p4", "4", "Numer paszport", "", true));

        string wartosc = "";
        string p31 = "", p34 = "";
        foreach (Soneta.Deklaracje.DefinicjaBloku defBlok in zcna.Bloki)
            foreach (Soneta.Deklaracje.DefinicjaPola defPole in defBlok.Pola)
                foreach (Pozycja pz in pozycje)
                    if (pz.Porownaj(defBlok.XmlTag, defPole.XmlTag)) {
                        wartosc = defPole.GetValue(zcna).ToString();
                        switch (defPole.Typ) {
                            case TypPolaDeklaracji.Bool:
                            case TypPolaDeklaracji.Int:
                                if (wartosc.ToLower() == "true")
                                    wartosc = "TAK";
                                else if (wartosc.ToLower() == "false")
                                    wartosc = "NIE";
                                break;
                        }
                        pz.Przypisz(wartosc);
                        if (pz.Blok == "III" && pz.Numer == "1")
                            p31 = wartosc;
                        else if (pz.Blok == "III" && pz.Numer == "4")
                            p34 = wartosc;
                        break;
                    }

        if (p31.Length > 0 || p34.Length > 0)
            foreach (Pozycja pz in pozycje)
                if (pz.Blok == "III" && (pz.Numer == "1" || pz.Numer == "4") && pz.Wartosc == empty)
                    pz.Wartosc = "";

        int pos = 1;
        string opis = "Dane o członku rodziny osoby ubezpieczonej uprawnionym do świadczeń z ubezpieczenia zdrowotnego";
        bool naliczajZCZA = !DeklaracjeModule.GetInstance(dc).Config.ZUS.Ogólne.NieNaliczajZCZA; 
        foreach (CzlonekRodziny osoba in zcna.Pracownik.Rodzina)
            if (osoba.UbezpieczenieOkres != FromTo.Empty && (!osoba.Adres.IsEmpty() || !naliczajZCZA)) {
                string pkt = "IV A (" + (pos++) + ")";
                string p1 = "", p2 = "";
                if (osoba.UbezpieczenieOkres.To == Date.MaxValue) {
                    p1 = "1";
                    p2 = osoba.UbezpieczenieOkres.From.ToString();
                } else {
                    p1 = "2";
                    p2 = osoba.UbezpieczenieOkres.To.ToString();
                }
                string p3 = osoba.PESEL;
                string p5 = "", p6 = "";
                if (osoba.Dokument.Rodzaj != 0 && Soneta.Deklaracje.ZUS.DefinicjaDAU.ZapiszNumerDokumentu(osoba, osoba.PESEL)) {
                    p5 = CaptionAttribute.EnumToString(osoba.Dokument.Rodzaj);
                    p6 = osoba.Dokument.SeriaNumer;
                }
                pozycje.Add(new Pozycja(pkt, opis, "p1", "1", "Zgłoszenie/Wyrejestrowanie członka rodziny", p1, true));
                pozycje.Add(new Pozycja(pkt, opis, "p2", "2", "Data uzyskania/utraty uprawnień do ubezpieczenia zdrowotnego przez członka rodziny", p2, false));
                pozycje.Add(new Pozycja(pkt, opis, "p3", "3", "Numer Pesel", p3, p3.Length == 0 && p6.Length == 0));
                pozycje.Add(new Pozycja(pkt, opis, "p4", "4", "Numer NIP", Soneta.Core.Nip.Flat(osoba.NIP), false));
                pozycje.Add(new Pozycja(pkt, opis, "p5", "5", "Rodzaj dokumentu", p5, false));
                pozycje.Add(new Pozycja(pkt, opis, "p6", "6", "Seria i numer dokumentu", p6, p3.Length == 0 && p6.Length == 0));
                pozycje.Add(new Pozycja(pkt, opis, "p7", "7", "Nazwisko", osoba.Nazwisko, true));
                pozycje.Add(new Pozycja(pkt, opis, "p8", "8", "Imię pierwsze", osoba.Imie, true));
                pozycje.Add(new Pozycja(pkt, opis, "p9", "9", "Data urodzenia", osoba.Urodzony.Data.ToString(), true));
                pozycje.Add(new Pozycja(pkt, opis, "p10", "10", "Kod stopnia pokrewieństwa", CaptionAttribute.EnumToString(osoba.StPokrewienstwa), true));
                pozycje.Add(new Pozycja(pkt, opis, "p11", "11", "Wspólne gospodarstwo domowe", (osoba.WspolneGospDomowe ? "TAK" : "NIE"), false));
                pozycje.Add(new Pozycja(pkt, opis, "p12", "12", "Kod stopnia niepełnosprawności", CaptionAttribute.EnumToString(osoba.StNiepelnosprawnosci), false));
            }
        
        Grid1.DataSource = pozycje;
    }

    void Grid1_BeforeRow(Object sender, RowEventArgs args) {
        Pozycja pz = (Pozycja)args.Row;
        if (pars.Braki)
            args.VisibleRow = pz.Wartosc == empty;
    }    
    
</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Deklaracja ZCNA</title> 
    <meta content="False" name="vs_showGrid" />
    <meta content="Microsoft Visual Studio 7.0" name="GENERATOR" />
    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<BODY>
        <FORM id="DeklaracjaZCNA" method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="OnContextLoad"></ea:DataContext>
			<eb:ReportHeader id="ReportHeader" runat="server" title="Deklaracja ZCNA"></eb:ReportHeader>
			<ea:Grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow" GroupLine="{0}. {1}" GroupData0="Blok" GroupData1="Tytul">
				<Columns>
					<ea:GridColumn runat="server" Align="Left" Caption="Pole" DataMember="Numer" Width="6"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Nazwa" DataMember="Opis"></ea:GridColumn>
					<ea:GridColumn runat="server" Align="Left" Caption="Wartość" DataMember="Wartosc" Width="30"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<eb:ReportFooter id="ReportFooter" runat="server"></eb:ReportFooter>
		</FORM>
	</BODY>
</html>
